﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Utilities;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace AZVIC.Ei8htPOS.WebUI.Admin.Reports
{
    public partial class RegisteredCustomers : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            WebSession.RedirectToAdminDashBoard(false);

            if (!IsPostBack)
            {
                BindCustomers(DateTime.MinValue, DateTime.MinValue);
            }
        }

        private void BindCustomers(DateTime fromDate, DateTime toDate)
        {
            DataTable customers = ReportsBL.GetRegisteredCustomers(fromDate, toDate);
            grdCustomers.DataSource = customers;
            grdCustomers.DataBind();

            if (customers.Rows.Count == 0)
                WebUtilities.ShowMessage(this, "No Customers found");
        }

        protected void btnExportToExcel(object sender, EventArgs e)
        {
            BindCustomers(DateTime.MinValue, DateTime.MinValue);
            Master.ExportToExcel<Entities.UserAccount>(grdCustomers, "RegisteredCustomers");
        }

        protected void grdCustomers_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            grdCustomers.PageIndex = e.NewPageIndex;
            BindCustomers((string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                                 (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)));
        }

        protected void grdCustomers_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {
                Label lblDOB = e.Row.FindControl("lblDOB") as Label;

                DataRowView cRow = (DataRowView)e.Row.DataItem;
                string dob = cRow["DOB"].ToString();

                lblDOB.Text = string.IsNullOrEmpty(dob) ? string.Empty : DateTime.Parse(dob).ToString("dd/MM/yyyy");
            }
        }

        protected void btnSearch_Click(object sender, EventArgs e)
        {
            if (txtFromDate.Text.Trim().Length != 0 && !ValidationUtility.ValidateDate(txtFromDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowMessage(this, "Please select valid From Date");
                return;
            }

            if (txtToDate.Text.Trim().Length != 0 && !ValidationUtility.ValidateDate(txtToDate.Text.Trim(), "dd/MM/yyyy"))
            {
                WebUtilities.ShowMessage(this, "Please select valid To Date");
                return;
            }

            BindCustomers((string.IsNullOrEmpty(txtFromDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtFromDate.Text.Trim(), "dd/MM/yyyy", null)),
                                 (string.IsNullOrEmpty(txtToDate.Text.Trim()) ? DateTime.MinValue : DateTime.ParseExact(txtToDate.Text.Trim(), "dd/MM/yyyy", null)));
        }

        protected void btnShowAll_Click(object sender, EventArgs e)
        {
            BindCustomers(DateTime.Now, DateTime.Now);
        }
    }
}